#include <stdio.h>
#include<winsock2.h>
#include <string.h>
#include <ws2tcpip.h> 
#include <stdlib.h>
#include <process.h>
#include <windows.h>


#pragma comment(lib, "ws2_32")

/*
	CHE COSA E' IBIS
	Ibis ver. 1.8 scritto da LeVante^   levante@manicomio.org  or  m.levante@gmail.com
	Questo  un broadcast scanner multithread per Windows.
	Serve a scovare gli indirizzi IP che restituiscono uno o pi d'un ping reply (quando pingati)
	e, come tutti sanno, pu essere utilizzato per ottenere una lista di amplificatori per smurf, ovvero
	pu essere usato per smurf/papasmurf/WinSmurf/Smurf2k/WSmurf...(e quanti pi ne conoscete... insomma *murf* ;-D).
	Tuttavia io preferisco dire che serve a trovare quali indirizzi rispondono agli ICMP ECHO REQUEST e con quanti reply.
	Ad eccezione di Nmap (che  decisamente molto di pi di un broadcast scanner) su Windows credo che esista soltanto un altro
	broadcast scanner che si chiama Ultimate Broadcast Scan scritto da un certo JC`zic.
	Anche se sono entrambe dei programmi eccellenti non sono riuscito a far funzionare Nmap sul mio pc (non so forse su Windows 
	richiede qualche driver/libreria/plugin, ho anche provato ad installare WinPcap ma senza alcun risultato) e l'UBS  troppo
	veloce per il mio processore o la mia connessione (infatti, una volta lanciato, il sistema diventa lento e dopo pochi minuti 
	la mia connessione muore completamente), per questi motivi ho deciso di scriverne uno io ex-novo. 
	Questo  Ibis (Italian Broadcast Ip Scanner)

	CARATTERISTICHE PRINCIPALI
	Con Ibis  possibile scegliere quanto veloce debba essere il nostro scan (usando un parametro di delay), si pu scegliere
	di salvare solo gli Ip con un certo determinato numero di risposte (DUPs), si pu scegliere di salvare l'output in un file 
	in 3 modi differenti, lo si pu eseguire in maniera silenziosa o visualizzando ogni richiesta/risposta, si pu effettuare 
	uno scan sull'intera Internet o solo su un certo spazio di indirizzi.
	Inoltre, sia l'Ultimate Broadcast Scan che molti altri broadcast scanner pingano soltanto gli indirizzi che terminano
	per 0 o 255, io ritengo ci non sia corretto o comunque che non sia sufficiente poich esistono migliaia e migliaia di
	altri indirizzi che non terminano con 0 o 255 e restituiscono parecchi ICMP ECHO REPLY, ad ogni modo,  sempre possibile 
	decidere di pingare solo gli indirizzi che terminano per 0 o 255 impostando il parametro -big

	REQUISITI
	Ibis  estremamente personalizzabile quindi non avrete bisogno di niente in particolare.
	Voglio semplicemente mettere in guardia gli utenti di Windows XP con il Service Pack 2. Questo programma  stato
	testato esclusivamente su Windows XP SP1; Ibis utilizza le Raw Socket che erano supportate nativamente sulla piattaforme 
	Windows fin dai tempi di Windows NT. Ho sentito dire che le raw socket sono state soppresse nel Service Pack 2
	e pare che la Microsoft abbia inibito questa caratteristica anche a qualunque utente Windows che abbia fatto l'aggiornamento 
	MS05-019. Personalmente io non ho avuto alcun problema ma comunque SOLO SE DOVESTE RISCONTRARE IL MANCATO/NON CORRETTO 
	FUNZIONAMENTO DI IBIS E PENSATE CHE POSSA ESSERE DOVUTO A QUESTO potete trovare informazioni su come riabilitare le raw
	socket a questo indirizzo http://seclists.org/lists/nmap-hackers/2005/Apr-Jun/0001.htm.
*/

typedef struct iphdr { 
	unsigned char  ver_len;
	unsigned char  tos;
	unsigned short tot_len;
	unsigned short id;
	unsigned short offset;
	unsigned char  ttl;
	unsigned char  protocol;
	unsigned short checksum;
	unsigned int   source;
	unsigned int   destination;
} IP_HDR;
#define IP_HDR_LEN sizeof(IP_HDR)

typedef struct icmphdr {
	unsigned char  type;
	unsigned char  code;
	unsigned short checksum;
	unsigned short id;  //questo  molto importante per calcolare i DUPs di ogni Ip
	unsigned short sequence;
	unsigned long  timestamp;
} ICMP_HDR;

typedef struct broadcast {
	int id;
	char ip[16];
	int dup;
} BROAD;


struct broadcast results[1024]; //dunque computiamo 1024 ip alla volta
SOCKET sock;
unsigned short ip_len;
unsigned char packet[32];
int mindup = 1, show = 1;
int initWinsock(void); //una funzione per inizializzare le Winsock
SOCKET CreateSocket(void); //questa  la funzione che crea la socket ed imposta le socket options necessarie al nostro scopo
void printHelp(char *pname); //questa funzione semplicemente stampa l'help men in caso di errori
unsigned short in_cksum(unsigned short *addr, int len); //una delle diffusissime funzioni per il calcolo del checksum
HANDLE mutex; // un semaforo che serve a regolarizzare gli accessi alla struttura broadcast quando vi si accede o dal main o da un thread
void receive(void *p);//questo  il thread

int main(int argc, char *argv[]){

	int a = 0, b = 0, c = 0, d = 0, i, delay = 70, big = 0, ot = 1;
	char scanip[16], endip[16] = "254.255.255.255", savepath[256] = "C:\\ibis.txt"; //alcuni valori di default
	unsigned short myid = 0, ip_v, totalsize;
	struct iphdr *ip = (struct iphdr *) packet;
	struct icmphdr *icmp = (struct icmphdr *) (packet + 20); //20 bytes  la lunghezza dell'header Ip
	struct sockaddr_in sin;
	FILE *fp;

	if(argc > 18 || argc < 2) {
		printf("\n\tERRORE! Il numero di parametri e' sbagliato!\n");
		Sleep(1500);
		printHelp(argv[0]);
	}
	// strettamente necessario specificare il PROPRIO indirizzo IP poich costruiremo il pacchetto in modo raw
	if(strlen(argv[1]) < 7 || strlen(argv[1]) > 15) {
		printf("\n\tERRORE! Devi specificare il TUO indirizzo Ip prima!\n\tUso: %s <proprio Ip> [opzioni]\n", argv[0]);
		Sleep(1500);
		printHelp(argv[0]);
	}

	//analisi delle opzioni immesse da linea di comando
	for(i=2;i<argc;i++) {
		if(!strcmp(argv[i], "-sa")) {
			if(strlen(argv[i+1]) < 7 || strlen(argv[i+1]) > 15 || sscanf(argv[i+1], "%d.%d.%d.%d", &a, &b, &c, &d) != 4) {
				printf("\n\tERRORE! L'indirizzo di partenza e' sbagliato (-sa)!\n\tUso: %s ... -sa xxx.xxx.xxx.xxx ...\n", argv[0]);
				Sleep(1500);
				printHelp(argv[0]);
			}
			else {
				i++;
				continue;
			}
		}
		
		if(!strcmp(argv[i], "-ea")) {
			if(strlen(argv[i+1]) >= 7 && strlen(argv[i+1]) <= 15) {
				strcpy(endip, argv[i+1]);
				i++;
				continue;
			}
			else {
				printf("\n\tERRORE! L'indirizzo di fine e' sbagliato (-ea)!\n\tUso: %s ... -ea xxx.xxx.xxx.xxx ...\n", argv[0]);
				Sleep(1500);
				printHelp(argv[0]);
			}
		}
		

		if(!strcmp(argv[i], "-d")) {
			delay = atoi(argv[i+1]);
			if(delay >= 0) {
				i++;
				continue;
			}
			else {
				printf("\n\tERRORE! Il delay deve essere un numero intero maggiore di 0.\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-dup")) {
			mindup = atoi(argv[i+1]);
			if(mindup > 0) {
				i++;
				continue;
			}
			else {
				printf("\n\tERRORE! Il numero minimo di DUPs deve essere almeno 1.\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-big")) {
			big = atoi(argv[i+1]);
			if(big == 0 || big == 1) {
				i++;
				continue;
			}
			else {
				printf("\n\tERRORE! Il parametro -big DEVE essere o 0 o 1\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}
	
		if(!strcmp(argv[i], "-ot")) {
			ot = atoi(argv[i+1]);
			if(ot == 1 || ot == 2 || ot == 3) {
				i++;
				continue;
			}
			else {
				printf("\n\tERRORE! Il parametro -ot DEVE essere o 1 o 2 o 3\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-show")) {
			show = atoi(argv[i+1]);
			if(show == 1 || show == 2 || show == 3) {
				i++;
				continue;
			}
			else {
				printf("\n\tERRORE! Il parametro -show DEVE essere o 1 o 2 o 3\n");
				Sleep(1500);
				printHelp(argv[0]);
			}
		}

		if(!strcmp(argv[i], "-of")) {
			strcpy(savepath, argv[i+1]);
			i++;
			continue;
		}
		
	}

	if((fp = fopen(savepath, "w")) == NULL) {
		fprintf(stderr, "\n\nERRORE! Impossibile aprire il file %s\n", savepath);
		exit(-1);
	}

	//Winsock: creazione e inizializzazione
	initWinsock();
	sock = CreateSocket();

	mutex = CreateMutex(NULL, FALSE, NULL);
	_beginthread( receive, 0, NULL); //il thread per ricevere i reply viene lanciato qui
	
	memset(packet, 0, 32);
	//Ora costruiremo il pacchetto manualmente, prima i campi Ip...
	ip_len = sizeof(struct iphdr) / sizeof(unsigned long);
	totalsize = sizeof(struct iphdr) + sizeof(struct icmphdr);
	ip_v = 4;
	ip->ver_len   = (ip_v << 4) | ip_len;
	ip->tos      = 0;
	ip->tot_len  = htons(totalsize);
	ip->id       = 1;
	ip->offset   = 0;
	ip->ttl      = 255;
	ip->protocol = IPPROTO_ICMP;
	ip->source    = inet_addr(argv[1]); //questo  l'Ip sorgente che abbiamo specificato da linea di comando
	//...e ora i campi di ICMP
	icmp->type     = 8;  //type: ICMP ECHO REQUEST
	icmp->code     = 0;
	//Tutti gli altri campi di IP e ICMP come l'Ip di destinazione o il checksum sia Ip che ICMP, verranno rimodificati e ricalcolati ogni volta
	
	//Se l'utente specifica un indirizzo di partenza, questo indirizzo va riarrangiato PRIMA del primo ciclo nel while altrimenti
	//al primo ciclo, tale indirizzo verr incrementato di 1 e l'indirizzo specificato dall'utente verr saltato
	if(!(a == 0 && b == 0 && c == 0 && d == 0)) {
		if(big == 1) {
			if(d == 255)
				d = 0; //se l'indirizzo di partenza termina con 255 allora impostiamo d = 0 cos al primo ciclo verr incrementato e sar proprio 255
			else
				d = 255;  //se invece l'indirizzo di partenza termina per 0 o con qualsiasi altro numero allora impostiamo d = 255 cos al primo ciclo verr messo a 0
		}
		else {
			/*
				Questo  stato corretto dalla vers. 1.7 alla 1.8
				Infatti come detto prima occorre diminuire l'IP di partenza di uno cos che il primo ciclon nel while lo incrementer
				di 1 facendo partire lo scan esattamente da dove aveva specificato l'utente. Nella vecchia versione questo avveniva
				facendo semplicemente d-- pensando (erroneamente) che anche se d diventava -1 il primo ciclo lo avrebbe ripristinato
				a 0. Questo ovviamente  del tutto sbagliato ed ho notato l'errore solo 2 giorni dopo. Infatti cos facendo  vero che
				d parte in modo corretto da 0 ma viene incrementato anche c facendo partire lo scan completamente da un altro
				indirizzo. Ora il bug  corretto e spero che sia tutto Ok. Mi scuso ancora per la svista.
			*/
			d--;
			if(d < 0) {
				d = 255;
				c--;
				if(c < 0) {
					c = 255;
					b--;
					if(b < 0) {
						b = 255;
						a--;
					}
				}
			}
		}
	}
	sin.sin_family = AF_INET;
	
	while(a <= 254) {
		if(!big) d = (d + 1) % 256;
		else {
			if(!d) d += 255;
			else if(d == 255) d -= 255;
		}
		if(!d) {
			c = (c + 1) % 256;
			if(!c) {
				b = (b + 1) % 256;
				if(!b) {
					a++;
				}
			}
		}
		
		sprintf(scanip,"%d.%d.%d.%d\0",a,b,c,d);
		if(show == 1)
			printf("Spedito ping a %s\n", scanip);
		//ecco i campi di Ip e ICMP che sono dinamici in questo programma
		ip->destination    = inet_addr(scanip);
		ip->checksum = 0;
		ip->checksum = in_cksum((unsigned short *)ip, sizeof(struct iphdr));  //checksum IP
		icmp->id       = htons(myid);  //myid inizia da 0 e fa si che vengano riempite tutte le 1024 locazioni dell'array, cos possiamo distinguere i reply
		icmp->sequence = (USHORT) htonl(rand()); 
		icmp->checksum = 0;
		icmp->checksum = in_cksum((unsigned short *)icmp, sizeof(struct icmphdr));  //checksum ICMP
		//quando abbiamo il possesso del semaforo e dunque l'accesso esclusivo all'array condiviso
		//impostiamo tutti i campi della locazione i-esima ad eccezone del campo dup che verr riempito dal thread
		//che si occupa di ricevere i reply
		WaitForSingleObject(mutex, INFINITE); 
		results[myid].id = myid;
		strcpy(results[myid].ip, scanip);
		results[myid].dup = 0;
		ReleaseMutex(mutex);
		myid++;
		//spediamo il pacchetto
		if(sendto(sock, packet, totalsize, 0x0, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) == SOCKET_ERROR) {
			printf("Errore: %d\n", WSAGetLastError());	
			free(ip);
			free(icmp);
			WSACleanup();
			exit(-1);
		}
		//Siamo alla fine dello scan?
		if(!strcmp(scanip, endip)) {
			Sleep(2000); //aspettiamo qualche secondo in pi gli ultimi reply
			WaitForSingleObject(mutex, INFINITE);
			for(i=0;i<myid;i++) {
				if(results[i].dup >= mindup) {
					if(ot == 1) {
						fprintf(fp, "%s\n", results[i].ip);
						fflush(fp);
					}
					else if(ot == 2) {
						fprintf(fp, "%s %d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
					else if(ot == 3) {
						fprintf(fp, "%s\t%d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
				}
			}
			if(show < 3)
				printf("\n\n---------IBIS Scan Completato---------\nL'intero output e' stato salvato in %s\n", savepath);
			CloseHandle(mutex);
			fclose(fp);
			closesocket(sock);
			WSACleanup();
			exit(0);
		}


		sprintf(scanip, "");
		//ogni 1024 ip bisogna svuotare il buffer e scrivere i risultati
		if(myid == 1024) {
			Sleep(1500); //aspettiamo qualche secondo in pi gli ultimi reply
			WaitForSingleObject(mutex, INFINITE);
			
			for(i=0;i<1024;i++) {
				if(results[i].dup >= mindup) {
					if(ot == 1) {
						fprintf(fp, "%s\n", results[i].ip);
						fflush(fp);
					}
					else if(ot == 2) {
						fprintf(fp, "%s %d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
					else if(ot == 3) {
						fprintf(fp, "%s\t%d\n", results[i].ip, results[i].dup);
						fflush(fp);
					}
				}
				//ovviamente dobbiamo anche resettare l'intero array
				results[i].dup = 0;
				results[i].id = 0;
				strcpy(results[i].ip, "");
			}
			myid = 0;
			ReleaseMutex(mutex);
		}
		//questo regola la velocit dell'intero scan
		if(delay > 0) Sleep(delay);
	}
    WSACleanup();
	exit(0);
}

int initWinsock(void){
 	WSADATA WSAData;
 	int err;
	if((err = WSAStartup(MAKEWORD(2,0), &WSAData)) != 0) {
		printf("\nUnable to initialize Winsock\n");
		exit(-1);
	}
	return(0);
}

SOCKET CreateSocket(void){
	int optval = 1;
	SOCKET socket;
	ULONG NonBlock;
	//Protocollo Ip in modalit Raw
	if((socket = WSASocket(AF_INET, SOCK_RAW, IPPROTO_ICMP, NULL, 0,0)) == INVALID_SOCKET){
		printf("\nERROR! Function() Raw Socket : %d\n", WSAGetLastError());
		WSACleanup();
		exit(-1);
	}
	
	if(setsockopt(socket, IPPROTO_IP, 2, (char *)&optval, sizeof(optval)) == SOCKET_ERROR)	{
   		printf("\nERROR! Function setsockopt() : %d\n", WSAGetLastError());
		WSACleanup();
   		exit(-1);
	}

	NonBlock = 1;
	//E' di fondamentale importanza che la socket sia NON bloccante altrimenti lo scan si bloccher ai primi cicli
    if(ioctlsocket(socket, FIONBIO, &NonBlock) == SOCKET_ERROR) {
        printf("\nERROR! ioctlsocket() failed \n");
        exit(-1);
    }
	 
	 if(setsockopt(socket, SOL_SOCKET, SO_BROADCAST, (const char *)&optval, sizeof(int) ) == SOCKET_ERROR) {
		printf("\nERROR! Function setsockopt() : %d\n", WSAGetLastError());
		WSACleanup();
   		exit(-1);
	 }
	
	return(socket);
}

unsigned short in_cksum(unsigned short *addr, int len){

    register int nleft = len;
    register u_short *w = addr;
    register int sum = 0;
    u_short answer = 0;

    while (nleft > 1) {
	sum += *w++;
	nleft -= 2;
    }

    if (nleft == 1) {
	*(u_char *) (&answer) = *(u_char *) w;
	sum += answer;
    }

    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    answer = ~sum;

    return (answer);
}

//Questo  il thread sempre attivo per ricevere gli ICMP ECHO REPLIES 
void receive(void *p) {
	int RetVal, typecheck;
	unsigned short idcheck;
	socklen_t clilen;
	struct sockaddr_in cliaddr;
	char buffer[1024];
	struct icmphdr *hdrICMPHeader;

	clilen = sizeof(cliaddr);
	for(;;) {
		memset((char *) &cliaddr, 0, sizeof(cliaddr));
		if((RetVal = recvfrom(sock, buffer, 1024, 0,(struct sockaddr *) &cliaddr, &clilen)) >= 0) {
			if (buffer[0] == 0x45)
				hdrICMPHeader = (struct icmphdr *) &(buffer[IP_HDR_LEN]);
			else
				hdrICMPHeader = (struct icmphdr *) buffer;

			idcheck = ntohs(hdrICMPHeader->id); //estraiamo il campo ID del reply
			typecheck = (int) hdrICMPHeader->type; //ed estraiamo anche il campo type. Occorre ricordare che ci interessano solo i type 0 ovvero ICMP ECHO REPLY!!
			
			WaitForSingleObject(mutex, INFINITE);
			//Se l'ID ritornato  uno di quelli immessi nella struttura allora aggiungiamo un DUP a quel determinato IP
			if(typecheck == 0 && idcheck < 1024 && results[idcheck].id == idcheck) {
				results[idcheck].dup++;
				if(show < 3)
					printf("\nRecevuto un ping reply. Aggiunto un DUP a %s\n", results[idcheck].ip);
			}
			ReleaseMutex(mutex);
		}
	}
}

void printHelp(char *pname) {
	fprintf(stderr, "\n\n\tItalian Broadcast Ip Scanner ver. 1.7 scritto da LeVante^\n\nUso: %s <proprio Ip> [opzioni]\n\nLista delle opzioni:\n -sa <indirizzo iniziale (default 0.0.0.1)>\n -ea <indirizzo finale (default 254.255.255.255)>\n -d <delay in millisecondi (default 70)>\n -dup <numero minimo di DUP (default 1)>\n -big <0 per pingare TUTTI gli indirizzi Ip | 1 per pingare i soli indirizzi\n       terminanti per 0 o 255 (default 0)>\n -ot <1 per salvare i risultati come semplice lista di Ip | 2 per una lista\n      con gli Ip ed i rispettivi DUP su ogni riga separati da uno SPAZIO\n      | 3 per una lista di Ip ed i rispettivi DUP su ogni riga separati\n       da un TAB (default 1)>\n -of <file in cui salvare l' output (default C:\\ibis.txt)>\n -show <1 per mostrare OGNI evento | 2 per mostrare solo i ping reply | 3 per\n       non mostrare nulla, silenzioso. (default 1)>\n\nLeggi l'help se riscontri qualche errore o vuoi vedere degli esempi\n", pname);
	WSACleanup();
	exit(-1);
}

